#!/bin/bash
if [ -f /etc/os-release ]; then
    # freedesktop.org and systemd
    . /etc/os-release
    OS=$NAME
    VER=$VERSION_ID
    if [[ "$OS" == "AlmaLinux" ]]; then
        OS=Alma
    fi
    
elif type lsb_release >/dev/null 2>&1; then
    # linuxbase.org
    OS=$(lsb_release -si)
    VER=$(lsb_release -sr)
else
    # Fall back to uname, e.g. "Linux <version>", also works for BSD, etc.
    OS=$(uname -s)
    VER=$(uname -r)
fi

VER=$(echo $VER | cut -d '.' -f 1)

if [[ "$OS" == "Alma" && "$VER" == "9" ]]; then
  
  echo -e "$4\n$4" | passwd  &&  echo "
TYPE=Ethernet

BOOTPROTO=static

DEFROUTE=yes

PEERDNS=yes

PEERROUTES=yes

USERCTL=no

NM_CONTROLLED=no

IPV4_FAILURE_FATAL=no

IPV6INIT=yes

IPV6_AUTOCONF=yes

IPV6_DEFROUTE=yes

IPV6_PEERDNS=yes

IPV6_PEERROUTES=yes

IPV6_FAILURE_FATAL=no

NAME=ens32

UUID=7280ff62-9dd1-410c-a7ac-5939282b920f

ONBOOT=yes

IPADDR=$2

NETMASK=255.255.255.0

GATEWAY=143.208.9.1

DNS1=8.8.8.8

DNS2=8.8.4.4

DOMAIN=server.test">/etc/sysconfig/network-scripts/ifcfg-ens32 &&  echo "nmcli con down ens32" && reboot 
fi
