function criar_campos(id, tipo) {

    var input = document.createElement("input");
    input.type = tipo;
    input.id = id;
    input.value = "";
    return input;
}
onloadBody = function() {
    var extensao = document.getElementById('extencao').value
    pesquisar_extensao_valor(extensao);
    var periodo = document.getElementById("periodo").value
    $("#idPeriodo").val(periodo);
    document.getElementById("idDesconto_Acrescimo").value = document.getElementById("desconto").value;
}
window.onload = function() {

    // Cria os campos ocultos para uso nas funções
    document.body.appendChild(criar_campos("idValor", "hidden"));
    document.body.appendChild(criar_campos("idDesconto_Acrescimo", "hidden"));
    document.body.appendChild(criar_campos("idPeriodo", "hidden"));

    // Carrega os dados
    onloadBody();

}

function set_total() {

    var idValor = parseFloat(document.getElementById("idValor").value);
    var idDesconto_Acrescimo = parseFloat(document.getElementById("idDesconto_Acrescimo").value);
    var idPeriodo = parseFloat(document.getElementById("idPeriodo").value);

    var total = 0;

    total = parseFloat(idValor);

    if (idPeriodo > 1) {

        total = parseFloat(total * idPeriodo);

    }

    if (idDesconto_Acrescimo != "" && !isNaN(idDesconto_Acrescimo)) {
        total = parseFloat(total + (total * (idDesconto_Acrescimo) / 100));
    }

    document.getElementById("valor").value = total;

    // Debug
    //alert("Valor: "+total);

    number_format("div_valor", total);

}

function pesquisar_dominio(dominio) {

    if (dominio) {




        var http = new Ajax();
        http.open("GET", "inc/funcoes.ajax.php?acao=pesquisar_dominio_whois&dominio=" + dominio, true);
        http.onreadystatechange = function() {

            if (http.readyState == 4) {
                resultado = http.responseText;
                if (resultado != "1") {

                    document.getElementById('div_status_dominio').innerHTML = '<div class="badge badge-danger"><i class="bi bi-x-circle"></i> Domínio indisponível  </div> '
                    $("#input_dominio").removeClass("loading");
                    $("#status_dominio").val("nao");
                    $("#btsalvar").hide();
                } else {
                    $("#input_dominio").removeClass("loading").addClass("error");
                    document.getElementById('div_status_dominio').innerHTML = '<div class="badge badge-success"><i class = "bi bi-check-circle"></i> Domínio disponível  </div> ';
                    $("#btsalvar").show();
                    $("#status_dominio").val("nao");
                }
            }
        }
        http.send(null);
        delete http;
    }
}

function pesquisar_extensao_valor(codigo) {



    if (codigo != "") {
        // $("#div_valor").addClass("loading");
        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";

        var http = new Ajax();
        http.open("GET", "inc/funcoes.ajax.php?acao=pesquisar_extensao_valor&codigo=" + codigo, true);
        http.onreadystatechange = function() {

            if (http.readyState == 4) {
                valor = http.responseText;

                // Grava os campos principais com os dados do plano
                document.getElementById("idValor").value = valor;

                set_total();

            }
        }
    }
    http.send(null);
    delete http;
}

function pesquisar_periodo_registro(periodo) {

    document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";

    if (periodo) {

        document.getElementById("idPeriodo").value = periodo;

        set_total();

    }

}

function number_format(div, valor) {

    var http = new Ajax();
    http.open("GET", "inc/funcoes.ajax.php?acao=number_format&valor=" + valor, true);
    http.onreadystatechange = function() {

        if (http.readyState == 4) {
            resultado = http.responseText;

            if (resultado) {
                document.getElementById(div).innerHTML = resultado;
            }
        }
    }
    http.send(null);
    delete http;
}

function desconto_acrescimo(valor) {

    if (valor != "") {

        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";


        valor = valor.replace(".", "");
        valor = valor.replace(",", ".");

        document.getElementById("idDesconto_Acrescimo").value = parseFloat(valor);

        set_total();
    } else {

        document.getElementById('div_valor').innerHTML = "<img src='img/spinner.gif' />";
        document.getElementById("idDesconto_Acrescimo").value = 0;

        set_total();
    }
}

function Ajax() {
    var req;

    try {
        req = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (e) {
        try {
            req = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (ex) {
            try {
                req = new XMLHttpRequest();
            } catch (exc) {
                alert("Esse browser não tem recursos para uso do Ajax");
                req = null;
            }
        }
    }

    return req;
}

function validar_caracteres(e, args) {
    if (document.all) { var evt = event.keyCode; } // caso seja IE
    else { var evt = e.charCode; } // do contrário deve ser Mozilla
    var valid_chars = '0123456789' + args; // criando a lista de teclas permitidas
    var chr = String.fromCharCode(evt); // pegando a tecla digitada
    if (valid_chars.indexOf(chr) > -1) { return true; } // se a tecla estiver na lista de permissão permite-a
    // para permitir teclas como <BACKSPACE> adicionamos uma permissão para
    // códigos de tecla menores que 09 por exemplo (geralmente uso menores que 20)
    if (valid_chars.indexOf(chr) > -1 || evt < 20) { return true; } // se a tecla estiver na lista de permissão permite-a
    return false; // do contrário nega
}